
-- Rain parameters
kPPS = 40;               -- Number of particles generated per second
kGravity =1000 ;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("flame2");
  SetBlendMode(kBlendNormal);
  SetNumParticles(500);
end

floor = math.floor
delayBeforeStart=800;
ParticlesPerSecond = NewParticleGenerator();
StopSpouting = NewTimeout(delayBeforeStart+4500);
TestDone = NewTimeout(8000+delayBeforeStart);
StartTime = NewTimeout(delayBeforeStart);

function Update(ms)

  if (not StartTime(ms)) then
   return;
  end
  
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitPosition( "vRange", Vec3(-5, -10), Vec3(5, 10) );
   InitVelocity( "vRange", Vec3(-40,10), Vec3(40,40) );
   InitScale( "fRange", 0.5, 1 );
   InitAge("iRange", 0, 0);
   CreateParticles(newParticles);
  end

Gravity(-.15* kGravity);

   Do("move");
   DoAge("iAge");
   
   DoScale("fScale",
      .85, 1500,
      .70, 1500);
   Do("expire", 800)

--DoUp( "vRotate", -.5, .5 );


end

